unit SmartDataGrid;

interface

uses
  HelperDB, SysUtils,
  System.Data, System.Web.UI, System.Web.UI.WebControls, System.ComponentModel;

type
  TSmartDataGrid = class(System.Web.UI.WebControls.DataGrid)
  private
    fErrorLabelText: &string;
    procedure SetErrorLabelText(const Value: string);
  private
    fRows: integer;
    fSelectSQL: string;
    fInsertSQL: string;
    fUpdateSQL: string;
    fDeleteSQL: string;
    fEditable: boolean;
    fErrorLabel: System.Web.UI.WebControls.Label;
    procedure SetRows(const Value: integer);
    function GetEditColumnIndex: integer;
    property EditColumnIndex : integer read GetEditColumnIndex;
    property ErrorLabelText: string read fErrorLabelText write SetErrorLabelText;


  strict protected
    procedure OnDataBinding(E : EventArgs); override;
		procedure OnDeleteCommand(E: DataGridCommandEventArgs); override;
		procedure OnEditCommand(E: DataGridCommandEventArgs); override;
		procedure OnCancelCommand(E: DataGridCommandEventArgs); override;
		procedure OnUpdateCommand(E: DataGridCommandEventArgs); override;
    procedure OnInit(E : EventArgs); override;
    procedure OnLoad(E : EventArgs); override;
    procedure OnItemCreated(E: DataGridItemEventArgs); override;
    procedure OnPageIndexChanged(E : DataGridPageChangedEventArgs); override;
  public
    constructor Create;
    procedure BindData;
    property Rows : integer read fRows write SetRows;
    property SelectSQL : string read fSelectSQL write fSelectSQL;
    property InsertSQL : string read fInsertSQL write fInsertSQL;
    property UpdateSQL : string read fUpdateSQL write fUpdateSQL;
    property DeleteSQL : string read fDeleteSQL write fDeleteSQL;

    property Editable : boolean read fEditable write fEditable;

    property ErrorLabel : System.Web.UI.WebControls.Label read fErrorLabel write fErrorLabel;
  end;

implementation


//DO NOT CALL DataBind from the aspx page! always call BindData!
procedure TSmartDataGrid.BindData;
var
  dv : DataView;
  ds : DataSet;
begin
  try
    ds := THelperDB.FillDataset(SelectSQL);
    if Assigned(ds) then
    begin
      dv := ds.Tables[0].DefaultView;
      DataSource := dv;
    	Rows := ds.Tables[0].Rows.Count;
	    if (CurrentPageIndex >= Rows / PageSize) then CurrentPageIndex:=0;
      DataBind;
    end;
  except on E:Exception do
    ErrorLabelText := 'Error in binding Grid '  + e.ToString();
  end;
end;

constructor TSmartDataGrid.Create;
begin
  inherited Create;
  // TODO: Add any constructor code here

  PagerStyle.Mode := PagerMode.NumericPages;
  PagerStyle.PageButtonCount := 5;
  PagerStyle.HorizontalAlign := System.Web.UI.WebControls.HorizontalAlign.Left;
  PagerStyle.Position:=PagerPosition.Bottom;

  fEditable := True;

  self.CssClass := 'SmartDataGrid';

end;


function TSmartDataGrid.GetEditColumnIndex: integer;
begin
  result := self.Columns.Count-1;
end;

procedure TSmartDataGrid.OnCancelCommand(E: DataGridCommandEventArgs);
begin
  inherited;

  EditItemIndex := -1;
  BindData;
end;

procedure TSmartDataGrid.OnDataBinding(E: EventArgs);
begin
  inherited;
end;

procedure TSmartDataGrid.OnDeleteCommand(E: DataGridCommandEventArgs);
var
  deleteKey:string;
begin
  inherited;

  if (EditItemIndex = -1) then
  begin
    if (Assigned(DeleteSQL)) AND (DeleteSQL <> EmptyStr) then
    begin
      deleteKey := DataKeys[e.Item.ItemIndex].ToString();
      ErrorLabelText := THelperDB.DeleteRecord(DeleteSQL + deleteKey);
      EditItemIndex := -1;
      BindData;
    end;
  end
  else
    ErrorLabelText := 'You need to cancel editing to be able to delete!';
end;

procedure TSmartDataGrid.OnEditCommand(E: DataGridCommandEventArgs);
begin
  inherited;

  EditItemIndex := e.Item.ItemIndex;
  BindData;
end;

procedure TSmartDataGrid.OnInit(E: EventArgs);
var
  EditColumn : EditCommandColumn;
begin
  inherited OnInit(E);

  EditColumn := EditCommandColumn.Create;
  with EditColumn do
  begin
    ButtonType:=ButtonColumnType.PushButton;
    CancelText:='Cancel';
    EditText := 'Edit';
    UpdateText := 'Save';
    ItemStyle.VerticalAlign := VerticalAlign.Top;
    ItemStyle.Width:=System.Web.UI.WebControls.Unit.Percentage(0);
    EditItemStyle.Width:=System.Web.UI.WebControls.Unit.Percentage(0);
  end;

  Columns.Add(EditColumn);
end;

procedure TSmartDataGrid.OnItemCreated(E: DataGridItemEventArgs);
var
  itemType : ListItemType;
  ecc : TableCell;
  lit : LiteralControl;
  DelBtn : Button;
	recFrom, recTo : integer;
begin
  inherited OnItemCreated(E);

	try
    itemType := e.Item.ItemType;
    If AllowPaging AND (itemType = ListItemType.Pager) Then
    begin//edit pager
      recFrom := 1 + CurrentPageIndex * PageSize;
		  recTo := PageSize + CurrentPageIndex * PageSize;
		  if recTo > Rows then recTo:=Rows;
      lit:=LiteralControl.Create;
      lit.Text:='Found ' + Rows.ToString + ' records. Displaying ' + recFrom.ToString + ' - ' + recTo.ToString + '.';
      lit.Text:= lit.Text + ' Goto page: ';
      ecc := (e.Item.Controls[0] as TableCell);
      ecc.Controls.AddAt(0,lit);
    end;

    If (itemType = ListItemType.Item) OR (itemType = ListItemType.AlternatingItem) OR (itemType = ListItemType.SelectedItem) Then
    begin//add delete button
       ecc := (e.Item.Controls[EditColumnIndex] as TableCell);

       //hide the edit button
       (ecc.Controls[0] as Button).Visible := Editable;
       (ecc.Controls[0] as Button).CssClass := 'SmartDataGrid_BUTTON';

			 lit:=LiteralControl.Create;
			 lit.Text:='&nbsp';
			 ecc.Controls.Add(lit);

			 DelBtn:=Button.Create;
       DelBtn.CssClass := 'SmartDataGrid_BUTTON';
			 DelBtn.CausesValidation := false;
			 DelBtn.CommandName:='DELETE';
			 DelBtn.Attributes.Add('onclick','return confirm(''Delete this entry?'')');
			 DelBtn.Text:='Delete';
			 ecc.Controls.Add(DelBtn)
		end;
    If (itemType = ListItemType.EditItem) Then
    begin// razmkni update i cancel buttone
      ecc := (e.Item.Controls[EditColumnIndex] as TableCell);
      (ecc.Controls[0] as Button).CausesValidation:=true; //update
      (ecc.Controls[2] as Button).CausesValidation:=false; //cancel
      (ecc.Controls[0] as Button).CssClass := 'SmartDataGrid_BUTTON'; //update
      (ecc.Controls[0] as Button).Font.Bold:=True;
      (ecc.Controls[2] as Button).CssClass := 'SmartDataGrid_BUTTON'; //cancel
      (ecc.Controls[2] as Button).Font.Bold:=True;
      try
        lit:=(ecc.Controls[1] as LiteralControl);
        lit.Text:='&nbsp';
      except
        lit:=LiteralControl.Create;
        lit.Text:='&nbsp';
        ecc.Controls.AddAt(1,lit);
      end;
    end;
	finally
	end;
end;

procedure TSmartDataGrid.OnLoad(E: EventArgs);
begin
  inherited;
end;

procedure TSmartDataGrid.OnPageIndexChanged(
  E: DataGridPageChangedEventArgs);
begin
  inherited;
  EditItemIndex:=-1;
  SelectedIndex:=-1;
  CurrentPageIndex := e.NewPageIndex;
  try
    BindData;
  except
    on E : Exception do
      ErrorLabelText:='Error: ' + E.Message;
  end;
end;

procedure TSmartDataGrid.OnUpdateCommand(E: DataGridCommandEventArgs);
begin
  inherited;
  if (Assigned(UpdateSQL)) AND (UpdateSQL <> EmptyStr) then
  begin
    ErrorLabelText := THelperDB.UpdateRecord(UpdateSQL);
  end;
  EditItemIndex := -1;
  BindData;
end;

procedure TSmartDataGrid.SetErrorLabelText(const Value: string);
begin
  fErrorLabelText := Value;

  if Assigned(ErrorLabel) then
    ErrorLabel.Text := Value;
end;

procedure TSmartDataGrid.SetRows(const Value: integer);
begin
  fRows := Value;
end;

end.
